* msys
org = $d400
 lst off
*-------------------------------
*
*  Music System ][
*  by Kyle Freeman
*  (c) 1986
*
*  Adapted by Jordan Mechner
*  July 1989
*
*-------------------------------
 org org

 jmp _MINIT
 jmp _MPLAY

*-------------------------------
MusicTable = $d000 ;start address of music data

*-------------------------------
MADRLO = MusicTable
MADRHI = MusicTable+$68

R = $00
INDEX = R+30

*-------------------------------
NOTE DFB 122,254,238,226,214,202,190,178,170,158,150,142,134
 DFB 126,118,112,106,100,94,88,84,78,74,70,66
 DFB 250,234,222,210,198,186,174,166,154,146,138,130
 DFB 122,114,108,102,96,90,84,80,74,70,66,62
 DFB 58,54,51,48,45,42,39,37,34,32,30,28
 DFB 26,24,22,21,19,18,17,16,15,14,13,12
 DFB 11,10,9
LENGTH DFB 28,4,4,4,4,4,5,5,5,6,6,6,7
 DFB 7,8,8,8,9,9,10,11,11,12,13,13
 DFB 14,15,16,17,18,19,20,21,23,24,25,27
 DFB 28,30,32,34,36,38,40,42,45,48,50,53
 DFB 57,60,64,67,71,76,81,84,91,95,101,107
 DFB 113,121,125,134,139,151,158,165,181,191,201,213
 DFB 227,242,255
MV0 HEX 0E0100FF
MV1 HEX 0E04020100FF
MV2 HEX 0E080604020100FF
MV3 HEX 0E0A080605040302010100FF
MV4 HEX 0E0A08070605040403037F02020202010101010100FF
MV5 HEX 010B0DFF
MV6 HEX 000103050B0DFF
MV7 HEX 000102030405060708090A0B0C0DFF
MV8 HEX 010E7F0200FF
MV9 HEX 01040E7F040100FF
MV10 HEX 010306090E7F0906030100FF
MV11 HEX 0E060B040803060205010501040003000200020001000100010001000100FF
MV12 HEX 01040E040D040C040B040B040B040B040B040B040B040B040B040B04FF
MV13 HEX 040E087F040100FF
MV14 HEX 0E02087F040100FF
 HEX 0B030A030903080307030603050304030403FF
MV15 HEX 01030B0301030B0301030B0301030B0301030B03
 HEX 01030B0301030B0301030B0201020401FF
HM1 DFB 1,3,128
HM2 DFB 3,1,1,1,1,1,1,2,2,1,1,1,1,1,2,1,2,1
 DFB 1,1,1,2,1,1,2,1,1,1,2,1,1,1,2,1,1
 DFB 2,1,1,1,1,2,1,2,1,1,1,1,1,2,2,1,1,1,1,1,1,128
HM3 DFB 3,1,1,1,1,2,2,1,1,1,2,1,2,1,1,2,1,1
 DFB 2,1,2,1,1,1,2,2,1,1,1,1,128
HM4 DFB 3,1,1,1,2,2,1,1,2,1,2,1,2,1,1,2,2,1,1,1,128
HM5 DFB 3,1,1,2,2,1,2,1,2,2,1,1,128
HM6 DFB 3,1,1,1,1,2,1,2,1,1,2,1,1,1,2,2,1,1
 DFB 1,1,2,2,1,1,1,2,1,1,2,1,2,1,1,1,1,128
HM7 DFB 3,1,2,2,2,1,128
HM8 DFB 3,1,1,1,1,2,1,1,2,1,2,1,1,1,1,2,2,1,1
 DFB 1,2,1,1,1,2,2,1,1,1,1,2,1,2,1,1,2,1,1,1,1,128
HM9 DFB 3,1,1,2,1,2,2,1,1,2,2,1,2,1,1,128
HM10 DFB 3,1,1,1,2,1,1,2,2,1,1,1,2,1,2,1,2
 DFB 1,1,1,2,2,1,1,2,1,1,1,128
HM11 DFB 3,1,1,1,1,1,1,1,2,1,1,1,1,1,1,2,2,1,1,1,1
 DFB 1,1,1,2,1,1,1,1,1,2,1,2,1,1,1,1,1,1,1
 DFB 2,1,1,1,1,2,1,1,2,1,1,1,1,1,1,1,2,1,1,1,2
 DFB 1,1,1,2,1,1,1,1,1,1,1,2,1,1,2,1,1,1,1
 DFB 2,1,1,1,1,1,1,1,2,1,2,1,1,1,1,1,2,1,1,1,1
 DFB 1,1,1,2,2,1,1,1,1,1,1,2,1,1,1,1,1,1,1,128
HM12 DFB 3,2,128
HM13 DFB 5,2,3,2,4,2,3,2,128
HM14 DFB 4,1,1,1,1,1,2,2,1,2,1,1,2,1,2,1,1,1,3,1,1
 DFB 2,1,1,2,1,1,2,2,1,2,1,1,1,1,2,3,1,1,1
 DFB 1,1,3,1,1,2,1,1,2,2,1,1,1,1,3,1,2,1,1,1,2
 DFB 1,1,3,1,1,2,1,1,1,2,1,3,1,1,1,1,2,2,1
 DFB 1,2,1,1,3,1,1,1,1,1,3,2,1,1,1,1,2,1,2,1,1
 DFB 1,2,1,1,2,1,1,3,1,1,1,2,1,2,1,1,2,1,2
 DFB 2,1,1,1,1,1,128
HM15 DFB 4,1,1,1,2,2,2,1,2,1,2,1,3,1,1,2,2,1,2,1
 DFB 3,1,1,1,3,2,1,1,2,1,3,1,2,1,1,2,3,1,1,1
 DFB 3,1,2,1,2,2,1,1,3,1,2,1,2,1,2,2,2,1,1,1
 DFB 128
HM16 DFB 4,1,1,2,2,2,2,1,2,2,2,1,3,1,1,3,2,1,2,1
 DFB 3,2,1,1,3,2,1,2,2,1,3,1,2,2,1,2,3,1,1,2
 DFB 3,1,2,1,2,3,1,1,3,1,2,2,2,1,2,2,2,2,1,1,128
HM17 DFB 4,1,1,1,1,2,2,1,2,1,2,1,2,1,1,2,2,1,2,1
 DFB 2,1,1,1,3,2,1,1,1,1,3,1,2,1,1,2,2,1,1,1
 DFB 3,1,2,1,1,2,1,1,3,1,2,1,1,1,2,2,2,1,1,1
 DFB 3,1,1,1,2,2,2,1,1,1,2,1,3,1,1,2,1,1,2,1
 DFB 3,1,1,1,2,2,1,1,2,1,3,1,1,1,1,2,3,1,1,1
 DFB 2,1,2,1,2,2,1,1,2,1,2,1,2,1,2,2,1,1,1,1
 DFB 128
HM18 DFB 3,128
HM19 HEX 030101010301010103010103010103018E
HM20 HEX 030303030303030303030303030303018E
HM21 HEX 050305030502040204020402040203018E
HM22 DFB 3,1,1,2,3,1,1,1,3,1,3,1,1,1,3,1,3,2,1,1
 DFB 1,2,1,1,3,1,1,1,1,1,1,1,3,2,1,1,1,1,3,1
 DFB 1,1,1,2,1,2,1,1,1,3,1,3,1,1,2,1,1,1,1,1
 DFB 1,1,3,1,1,3,2,1,1,1,3,1,1,1,3,1,1,2,1,1
 DFB 3,1,1,2,1,1,1,1,1,1,3,2,1,1,1,3,1,1,3,1
 DFB 1,3,1,2,2,1,1,1,1,1,3,1,1,3,1,1,1,3,1,1
 DFB 1,1,1,1,3,1,1,2,1,1,1,2,3,1,1,2,1,1,3,1
 DFB 1,1,3,1,2,1,1,1,3,1,1,2,1,1,3,2,1,1,1,3
 DFB 1,1,2,1,1,1,3,1,1,3,1,1,1,3,1,2,1,3,1,1
 DFB 128
HM23 DFB 4,1,2,1,1,4,1,1,2,1,4,1,2,4,1,1,2,1,4
 DFB 1,3,1,2,4,1,3,1,2,1,1,1,3,1,4,1,3,1,2,1,3
 DFB 1,2,1,2,1,3,1,4,1,3,1,1,2,1,1,1,3,1,1
 DFB 4,1,2,1,2,1,3,1,1,4,1,4,1,1,2,1,1,4,1,1,2
 DFB 1,3,1,4,1,1,2,1,4,1,1,1,2,1,1,4,1,1,1
 DFB 3,1,1,2,1,1,1,4,1,1,2,1,1,4,1,1,2,1,1,4,1
 DFB 4,1,1,3,1,1,2,1,4,1,2,1,1,4,1,1,3,1,1
 DFB 4,1,1,3,1,4,1,2,1,4,1,1,4,1,1,2,1,2,1,4,1
 DFB 1,1,1,3,1,2,1,2,1,4,1,1,3,1,4,1,3,1,1
 DFB 2,1,4,1,2,1,1,4,1,1,1,3,1,2,1,4,1,2,1,1,1
 DFB 4,1,1,2,1,4,1,3,1,4,1,1,2,1,1,2,1,1,1
 DFB 4,1,3,1,1,2,1,4,1,1,1,2,1,1,4,1,3,1,4,1,1
 DFB 1,1,2,1,4,1,1,128
HM24 DFB 3,3,3,3,3,3,3,1,3,1,3,1,3,1,3,1,3,1,3
 DFB 1,1,3,1,1,3,1,1,3,1,1,3,1,1,3,1,1,3,1,1,1
 DFB 3,1,1,1,3,1,1,1,3,1,1,1,3,1,1,1,3,1,1
 DFB 1,3,1,1,3,1,1,3,1,1,3,1,1,3,1,1,3,1,1,3,1
 DFB 3,1,3,1,3,1,3,1,3,1,128
HM25 DFB 3,3,3,1,3,1,3,1,1,3,1,1,3,1,1,1,3,1,1,1,3,1,1,3,1,1,3,1,3,1,128
HM26 DFB 3,3,1,1,1,1,3,3,3,128
HM27 DFB 3,3,1,1,3,1,3,1,1,128
HM28 DFB 3,3,1,128
HM29 HEX 0303030303030103010301030101038D
HM30 DFB 3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3
 DFB 1,1,3,1,1,3,1,3,1,3,3,3,3,3,1,3,1,146
HM31 DFB 1,4,128
HM32 DFB 1,3,128
HARMTBL DFB #<HM1
 DFB #<HM2
 DFB #<HM3
 DFB #<HM4
 DFB #<HM5
 DFB #<HM6
 DFB #<HM7
 DFB #<HM8
 DFB #<HM9
 DFB #<HM10
 DFB #<HM11
 DFB #<HM12
 DFB #<HM13
 DFB #<HM14
 DFB #<HM15
 DFB #<HM16
 DFB #<HM17
 DFB #<HM18
 DFB #<HM19
 DFB #<HM20
 DFB #<HM21
 DFB #<HM22
 DFB #<HM23
 DFB #<HM24
 DFB #<HM25
 DFB #<HM26
 DFB #<HM27
 DFB #<HM28
 DFB #<HM29
 DFB #<HM30
 DFB #<HM31
 DFB #<HM32
HARMTBH DFB #>HM1
 DFB #>HM2
 DFB #>HM3
 DFB #>HM4
 DFB #>HM5
 DFB #>HM6
 DFB #>HM7
 DFB #>HM8
 DFB #>HM9
 DFB #>HM10
 DFB #>HM11
 DFB #>HM12
 DFB #>HM13
 DFB #>HM14
 DFB #>HM15
 DFB #>HM16
 DFB #>HM17
 DFB #>HM18
 DFB #>HM19
 DFB #>HM20
 DFB #>HM21
 DFB #>HM22
 DFB #>HM23
 DFB #>HM24
 DFB #>HM25
 DFB #>HM26
 DFB #>HM27
 DFB #>HM28
 DFB #>HM29
 DFB #>HM30
 DFB #>HM31
 DFB #>HM32
ENVTBL DFB #<MV0
 DFB #<MV1
 DFB #<MV2
 DFB #<MV3
 DFB #<MV4
 DFB #<MV5
 DFB #<MV6
 DFB #<MV7
 DFB #<MV8
 DFB #<MV9
 DFB #<MV10
 DFB #<MV11
 DFB #<MV12
 DFB #<MV13
 DFB #<MV14
 DFB #<MV15
ENVTBH DFB #>MV0
 DFB #>MV1
 DFB #>MV2
 DFB #>MV3
 DFB #>MV4
 DFB #>MV5
 DFB #>MV6
 DFB #>MV7
 DFB #>MV8
 DFB #>MV9
 DFB #>MV10
 DFB #>MV11
 DFB #>MV12
 DFB #>MV13
 DFB #>MV14
 DFB #>MV15
MVOLTBL HEX 4A4AEA0A0A4969D0
MVT2 HEX 4AEAEAEA0A0F0704
VTBL HEX 0001020304
HTPTBL DFB 0,24,19,16,12,22,7,24,16,22,35,0,0,26,19,16,24
 DFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
AMPTBL DFB 1,2,3,4,5,7,9,11,14,17,21,26,32,39,47,56
MINIT LDA #$EA
 STA VATC1
 STA VATC2
 STA VXAT1
 STA VXAT2
 LDA #<HM1
 STA MBASS1+1
 STA MMBASS2+1
 LDA #>HM1
 STA MBASS1+2
 STA MMBASS2+2
 LDA #0
 STA R+5
 STA $AF
 STA $B6
 STA R+4
 LDX INDEX
 LDA MADRLO,X
 STA R+0
 LDA MADRHI,X
 STA R+1
 LDA #0
 STA R+15
 STA R+24
 STA R+27
NEWNOTE LDY #0
 STY R+12
 STY R+3
 LDA #1
 STA MLBL300+1
 INC R+0
 INC R+0
 BNE MNOWIC
 INC R+1
MNOWIC LDA (R+0),Y
 TAX
 INY
 LDA (R+0),Y
 BEQ MSYSTM1
 TXA
 AND #%11111100
 STA R+13
 BEQ MNOBC1
 LSR
 LSR
 CLC
 ADC R+4
 STA R+13
 CMP #$19
 BGE MNOBC1
 LDA #7
 STA MLBL300+1
MNOBC1 LDA (R+0),Y
 BEQ MSYSTM1
 JMP NMSYSM
MSYSTM1 TXA
 BEQ MINIT
 CMP #$FE
 BNE MXNQ10
 LDY R+24
 BEQ MXQN8
MRET1 LDA R+25
 STA R+0
 LDA R+26
 STA R+1
 LDA #0
 STA R+24
MXQN8 JMP NEWNOTE
MXNQ10 CMP #$FD
 BNE MXQN9
 LDX $1E60
 LDA $1E80,X
 ORA #$80
 STA $1E80,X
 JMP NEWNOTE
MXQN9 CMP #$FF
 BNE NOPAUS1
 STA R+10
 LDA #0
 STA R+13
 LDA NOTE
 STA R+8
 LDA LENGTH
 STA R+9
 RTS
NOPAUS1 CPX #9
 BGE SYMPH01
 LDA MVOLTBL-1,X
 STA VATC1
 LDA MVT2-1,X
 STA VXAT1
 JMP NEWNOTE
SYMPH01 TXA
 LDX #0
 STX R+4
 SEC
 SBC #9
 CMP #32
 BGE HOCTSFT1
GOHERE4 TAX
 STX $AF
 LDA HTPTBL,X
 CLC
 ADC R+4
 STA R+4
 LDA HARMTBL,X
 STA MBASS1+1
 LDA HARMTBH,X
 STA MBASS1+2
 JMP NEWNOTE
HOCTSFT1 LDX #12
 STX R+4
 AND #$1F
 JMP GOHERE4
NMSYSM TAY
 AND #%00111111
 BEQ MMGA03
 JMP NTVJNK
MMGA03 TYA
 AND #%11000000
 CMP #%10000000
 BNE MNSSC1
 DEX
 BMI ALTSNG
 STX INDEX
ALTSNG1 JMP NEWNOTE
ALTSNG LDY $1E60
 LDA $1E80,Y
 BPL ALTSNG1
 TXA
 AND #$7F
 STA INDEX
 JMP MINIT
MNSSC1 CMP #%01000000
 BNE MGARY5
 LDA #1
 STA R+15
 STA R+21
 TXA
 LDX R+0
 STX R+22
 LDX R+1
 STX R+23
 ASL
 BCS NOTVI1
 ADC R+0
 STA R+0
 LDA #0
 ADC R+1
 STA R+1
 JSR MMNNOTE
 JMP NEWNOTE
MGARY5 LDA R+24
 BEQ MMGAR3
 JMP MRET1
MMGAR3 LDA #1
 STA R+24
 TXA
 LDX R+0
 STX R+25
 LDX R+1
 STX R+26
 ASL
 STA R+14
 BCS NOTRP1
 LDA R+0
 SEC
 SBC R+14
 STA R+0
 LDA R+1
 SBC #0
 STA R+1
 JMP NEWNOTE
NOTRP1 LDA R+0
 SBC R+14
 STA R+0
 LDA R+1
 SBC #0
 STA R+1
 DEC R+1
 JMP NEWNOTE
NOTVI1 CLC
 ADC R+0
 STA R+0
 LDA #0
 ADC R+1
 STA R+1
 INC R+1
 JSR MMNNOTE
 JMP NEWNOTE
NTVJNK STA R+10
 TYA
 AND #%11000000
 LSR
 LSR
 LSR
 LSR
 STA R+7
 TXA
 AND #%00000011
 ORA R+7
 TAX
 LDA AMPTBL,X
 STA R+11
 LDA ENVTBL,X
 STA MVAR6+1
 LDA ENVTBH,X
 STA MVAR6+2
 LDX R+13
 LDA NOTE,X
 STA R+8
 LDA LENGTH,X
 STA R+9
 RTS
MPLAY LDA R+15
 BEQ NO2VOI
 LDA R+21
 EOR #1
 STA R+21
 BNE NO2VOI
 JMP MMPLAY
V8HOLD LDA R+12
 CMP R+10
 BLT MESKP
 INC R+12
NO2VOI LDY R+12
MVAR6 LDA $FFFF,Y
 BMI MESKP
 CMP #$7F
 BEQ V8HOLD
VATC1 ASL
VXAT1 ASL
 STA R+11
 INC R+12
MESKP LDA $AF
 BNE NEWMM4
 LDA #0
 STA R+3
NEWMM4 LDA R+11
 STA VTBL+2
 LSR
 STA VTBL+1
 CLC
 ADC R+11
 STA VTBL+3
 LDA R+11
 ASL
 STA VTBL+4
 INC VTBL+1
 INC VTBL+2
 INC VTBL+3
 INC VTBL+4
 LDX R+9
 LDA R+13
 BNE MSEGL5
 STA VTBL+1
 STA VTBL+2
 STA VTBL+3
 STA VTBL+4
MSEGL5 JMP MSEG
MSEGL4 AND #$7F
 STA R+3
MSEG
 LDY R+3
MBASS1 LDA HM1,Y
 BMI MSEGL4
 INC R+3
 TAY
 LDA VTBL-1,Y
 STA R+6
 SEC
 SBC R+8
 TAY
MADJLP INY
 BNE MADJLP
MLBL300 LDY #1
MLMDI LDA R+8
 SEC
MDLOOP SBC #1
 BNE MDLOOP
 DEY
 BNE MLMDI
 LDY R+6
 BEQ MFIZZLE
M30A LDA $C030
MVDIT DEY
 BNE MVDIT
M30B LDA $C030
MFIZZLE DEX
 BNE MSEG
 DEC R+10
 BNE LBL10
 JMP NEWNOTE
LBL10 RTS
MMINIT LDA #0
 STA R+15
 RTS
MMNNOTE LDY #0
 STY R+2
 STY R+16
 LDA #1
 STA MMLM302+1
 INC R+22
 INC R+22
 BNE MMNOWIC
 INC R+23
MMNOWIC LDA (R+22),Y
 TAX
 INY
 LDA (R+22),Y
 BEQ MSYSTM2
 TXA
 AND #%11111100
 STA R+17
 BEQ MMNOBC2
 LSR
 LSR
 CLC
 ADC R+5
 STA R+17
 CMP #$19
 BGE MMNOBC2
 LDA #7
 STA MMLM302+1
MMNOBC2 LDA (R+22),Y
 BNE NMMSYSMM
MSYSTM2 TXA
 BEQ MMINIT
 CMP #$FE
 BNE MXQN6
 LDY R+27
 BEQ MXQN5
MRET2 LDA R+28
 STA R+22
 LDA R+29
 STA R+23
 LDA #0
 STA R+27
MXQN5 JMP MMNNOTE
MXQN6 CMP #$FF
 BNE NOPAUS2
 STA R+18
 LDA #0
 STA R+17
 LDA NOTE
 STA R+19
 LDA LENGTH
 STA R+20
 RTS
NOPAUS2 CPX #9
 BGE SYMPH02
 LDA MVOLTBL-1,X
 STA VATC2
 LDA MVT2-1,X
 STA VXAT2
 JMP MMNNOTE
SYMPH02 TXA
 LDX #0
 STX R+5
 SEC
 SBC #9
 CMP #32
 BGE HOCTSFT4
GOHERE8 TAX
 STX $B6
 LDA HTPTBL,X
 CLC
 ADC R+5
 STA R+5
 LDA HARMTBL,X
 STA MMBASS2+1
 LDA HARMTBH,X
 STA MMBASS2+2
KFMM465 JMP MMNNOTE
HOCTSFT4 LDX #12
 STX R+5
 AND #$1F
 JMP GOHERE8
NMMSYSMM TAY
 AND #%00111111
 BNE M2NTV
 TYA
 AND #%11000000
 CMP #%11000000
 BNE KFMM465
 LDA R+27
 BNE MRET2
 LDA #1
 STA R+27
 TXA
 LDX R+22
 STX R+28
 LDX R+23
 STX R+29
 ASL
 STA R+14
 BCS NOTRP2
 LDA R+22
 SEC
 SBC R+14
 STA R+22
 LDA R+23
 SBC #0
 STA R+23
NOTRP2 LDA R+22
 JMP MMNNOTE
 SBC R+14
 STA R+22
 LDA R+23
 SBC #0
 STA R+23
 DEC R+23
 JMP MMNNOTE
M2NTV STA R+18
 TYA
 AND #%11000000
 LSR
 LSR
 LSR
 LSR
 STA R+7
 TXA
 AND #%00000011
 ORA R+7
 TAX
 LDA AMPTBL,X
 STA $B7
 LDA ENVTBL,X
 STA MVAR2C+1
 LDA ENVTBH,X
 STA MVAR2C+2
 LDX R+17
 LDA NOTE,X
 STA R+19
 LDA LENGTH,X
 STA R+20
 RTS
MV8HOLD LDA R+16
 CMP R+18
 BLT MMESKP
 INC R+16
MMPLAY LDY R+16
MVAR2C LDA $FFFF,Y
 BMI MMESKP
 CMP #$7F
 BEQ MV8HOLD
VATC2 ASL
VXAT2 ASL
 STA $B7
 INC R+16
MMESKP LDA $B6
 BNE NEWMM5
 LDA #0
 STA R+2
NEWMM5 LDA $B7
 STA VTBL+2
 LSR
 STA VTBL+1
 CLC
 ADC $B7
 STA VTBL+3
 LDA $B7
 ASL
 STA VTBL+4
 INC VTBL+1
 INC VTBL+2
 INC VTBL+3
 INC VTBL+4
 LDX R+20
 LDA R+17
 BNE MMSEGL5
 STA VTBL+1
 STA VTBL+2
 STA VTBL+3
 STA VTBL+4
MMSEGL5 JMP MMSEG
MMSEGL4 AND #$7F
 STA R+2
MMSEG
 LDY R+2
MMBASS2 LDA HM1,Y
 BMI MMSEGL4
 INC R+2
 TAY
 LDA VTBL-1,Y
 STA R+6
 SEC
 SBC R+19
 TAY
MMADJLP INY
 BNE MMADJLP
MMLM302 LDY #1
MMLMMDI LDA R+19
 SEC
MMDLOOP SBC #1
 BNE MMDLOOP
 DEY
 BNE MMLMMDI
 LDY R+6
 BEQ MMFIZZY
M20A LDA $C030
MMVDIT DEY
 BNE MMVDIT
M20B LDA $C030
MMFIZZY DEX
 BNE MMSEG
 DEC R+18
 BNE MLZ10
 JMP MMNNOTE
MLZ10 RTS

*-------------------------------
*
*  M I N I T
*
*  Inititalize music system & prepare to play a song
*
*  In: A = song #
*
*-------------------------------
_MINIT sta INDEX
 jmp MINIT

*-------------------------------
*
*  M P L A Y
*
*  Continue playing current song
*  (Generates a fraction of a second of sound)
*
*  Out: A = current song #
*  (Most songs set song #0 when finished.)
*
*  NOTE: MSYS uses aux z.p. locations $00-1F.  These must
*  remain undisturbed for the duration of each song.
*
*-------------------------------
_MPLAY jsr MPLAY
 lda INDEX
 rts

*-------------------------------
 lst
eof ds 1
 usr $a9,34,$600,*-org
 lst off
